<?php

namespace Drupal\vertex_ai_search\Service;

/**
 * Defines Vertex AI Search manager service.
 */
interface VertexSearchManagerInterface {

  /**
   * Perform a Search.
   *
   * @param array $search_configuration
   *   Configuration associated with custom search page.
   * @param array $search_parameters
   *   Parameters for performing a search.
   *
   * @return array
   *   An array of Search results, config data, and metadata.
   */
  public function executeSearch(array $search_configuration, array $search_parameters);

}
