<?php

namespace Drupal\Tests\vertex_ai_search\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\vertex_ai_search\VertexConfigurableJavaScriptPluginManager;

/**
 * Test to ensure 'plugin.manager.vertex_configurable_js' service is reachable.
 *
 * @group vertex_ai_search
 *
 * @ingroup vertex_ai_search
 */
class VertexConfigurableJavaScriptPluginManagerTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['vertex_ai_search', 'search'];

  /**
   * Test for existence of 'plugin.manager.vertex_configurable_js' service.
   */
  public function testConfigurableJavaScriptPluginManagerService() {
    $service = $this->container->get('plugin.manager.vertex_configurable_js');
    $this->assertInstanceOf(VertexConfigurableJavaScriptPluginManager::class, $service);
  }

}
