<?php

namespace Drupal\Tests\vertex_ai_search\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\vertex_ai_search\VertexSearchFilterPluginManager;

/**
 * Test to ensure 'plugin.manager.vertex_search_filter' service is reachable.
 *
 * @group vertex_ai_search
 *
 * @ingroup vertex_ai_search
 */
class VertexSearchFilterPluginManagerTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['vertex_ai_search', 'search'];

  /**
   * Test for existence of 'plugin.manager.vertex_search_filter' service.
   */
  public function testSearchFilterPluginManagerService() {
    $service = $this->container->get('plugin.manager.vertex_search_filter');
    $this->assertInstanceOf(VertexSearchFilterPluginManager::class, $service);
  }

}
