<?php

namespace Drupal\Tests\vertex_ai_search\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\vertex_ai_search\VertexSearchResultsPluginManager;

/**
 * Test to ensure 'plugin.manager.vertex_search_results' service is reachable.
 *
 * @group vertex_ai_search
 *
 * @ingroup vertex_ai_search
 */
class VertexSearchResultsPluginManagerTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['vertex_ai_search', 'search'];

  /**
   * Test for existence of 'plugin.manager.vertex_search_results' service.
   */
  public function testSearchResultsPluginManagerService() {
    $service = $this->container->get('plugin.manager.vertex_search_results');
    $this->assertInstanceOf(VertexSearchResultsPluginManager::class, $service);
  }

}
