<?php

/**
 * @file
 * Vertex AI Search token support.
 */

use Drupal\Core\Render\BubbleableMetadata;

/**
 * Implements hook_token_info().
 */
function vertex_ai_search_token_info() {

  $type = [
    'name' => t('Vertex AI Search'),
    'description' => t('Vertex AI search results information.'),
    'needs-data' => 'array',
  ];

  $tokens['vertex_ai_search_keywords'] = [
    'name' => t('Vertex AI Search Keywords'),
    'description' => t('The keywords used in a Vertex AI search.'),
  ];

  $tokens['vertex_ai_search_result_start'] = [
    'name' => t('Vertex AI Search Result Starting Number'),
    'description' => t('The number of the first result being displayed on a page.'),
  ];

  $tokens['vertex_ai_search_result_end'] = [
    'name' => t('Vertex AI Search Result Ending Number'),
    'description' => t('The number of the last result being displayed on a page.'),
  ];

  $tokens['vertex_ai_search_page'] = [
    'name' => t('Vertex AI Search Page Name'),
    'description' => t('The current search page name of a Vertex AI search.'),
  ];

  $tokens['vertex_ai_search_total_result_count'] = [
    'name' => t('Vertex AI Search Total Result Count'),
    'description' => t('The total number of results up to the configuration limit.'),
  ];

  $tokens['vertex_ai_search_estimated_result_count'] = [
    'name' => t('Vertex AI Search Estimated Result Count'),
    'description' => t('The estimated number of results in the index.'),
  ];

  $tokens['vertex_ai_search_original_keyword'] = [
    'name' => t('Vertex AI Search Original Keyword'),
    'description' => t('The original keywords if keyword correction detected.'),
  ];

  $tokens['vertex_ai_search_original_keyword_url'] = [
    'name' => t('Vertex AI Search Original Keyword Search URL'),
    'description' => t('The URL to search against original keywords if keyword correction detected.'),
  ];

  $tokens['vertex_ai_search_corrected_keyword'] = [
    'name' => t('Vertex AI Search Corrected Keyword'),
    'description' => t('The corrected keywords if keyword correction detected.'),
  ];

  $tokens['vertex_ai_search_corrected_keyword_url'] = [
    'name' => t('Vertex AI Search Corrected Keyword Search URL'),
    'description' => t('The URL to search against corrected keywords if keyword correction detected.'),
  ];

  return [
    'types' => ['vertex_ai_search' => $type],
    'tokens' => [
      'vertex_ai_search' => $tokens,
    ],
  ];
}

/**
 * Implements hook_tokens().
 */
function vertex_ai_search_tokens($type, array $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata) {

  $replacements = [];

  if ($type == 'vertex_ai_search' && !empty($data['vertex_ai_search'])) {

    foreach ($tokens as $name => $original) {
      switch ($name) {

        case 'vertex_ai_search_keywords':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_keywords'];
          break;

        case 'vertex_ai_search_result_start':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_result_start'];
          break;

        case 'vertex_ai_search_result_end':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_result_end'];
          break;

        case 'vertex_ai_search_page':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_page'];
          break;

        case 'vertex_ai_search_original_keyword':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_original_keyword'];
          break;

        case 'vertex_ai_search_original_keyword_url':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_original_keyword_url'];
          break;

        case 'vertex_ai_search_corrected_keyword':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_corrected_keyword'];
          break;

        case 'vertex_ai_search_corrected_keyword_url':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_corrected_keyword_url'];
          break;

        case 'vertex_ai_search_total_result_count':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_total_result_count'];
          break;

        case 'vertex_ai_search_estimated_result_count':
          $replacements[$original] = $data['vertex_ai_search']['vertex_ai_search_estimated_result_count'];
          break;
      }
    }
  }

  return $replacements;
}
