<?php

namespace Drupal\vertex_ai_search\Service\Decorator;

use Drupal\Core\Pager\PagerManager;

/**
 * A Decorator for PagerManager supporting Vertex Custom Search.
 *
 * Vertex Custom Search only returns 100 results, even if
 * there are thousands of results found.  This class modifies
 * the search pager so that it shows the total number of
 * Vertex results, while limiting the pager to 10 pages.
 */
class VertexPagerManager extends PagerManager {

  /**
   * {@inheritdoc}
   */
  public function createVertexPager($total, $limit, $element = 0) {
    $currentPage = $this->pagerParams->findPage($element);

    // $total pages is the number of Vertex search results.
    $pager = new VertexPager($total, $limit, $currentPage);
    $this->setPager($pager, $element);
    return $pager;
  }

}
