<?php

namespace Drupal\vertex_ai_search;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * VertexConfigurableJavaScriptPlugin plugin manager.
 */
class VertexConfigurableJavaScriptPluginManager extends DefaultPluginManager {

  /**
   * Constructs VertexConfigurableJavaScriptPluginManager.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/ConfigurableJavaScript',
      $namespaces,
      $module_handler,
      'Drupal\vertex_ai_search\Plugin\VertexConfigurableJavaScriptPluginInterface',
      'Drupal\vertex_ai_search\Annotation\VertexConfigurableJavaScriptPlugin'
    );

    $this->setCacheBackend($cache, 'vertex_configurable_javascript_plugins');
    $this->alterInfo('vertex_configurable_javascript_plugin');
  }

}
