<?php

namespace Drupal\Tests\vertex_ai_search\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\vertex_ai_search\VertexAutocompletePluginManager;

/**
 * Test to ensure 'plugin.manager.vertex_autocomplete' service is reachable.
 *
 * @group vertex_ai_search
 *
 * @ingroup vertex_ai_search
 */
class VertexAutocompletePluginManagerTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['vertex_ai_search', 'search'];

  /**
   * Test for existence of 'plugin.manager.vertex_autocomplete' service.
   */
  public function testAutocompletePluginManagerService() {
    $service = $this->container->get('plugin.manager.vertex_autocomplete');
    $this->assertInstanceOf(VertexAutocompletePluginManager::class, $service);
  }

}
