<?php

namespace Drupal\vertex_ai_search\Plugin\ConfigurableJavaScript;

use Drupal\Core\Form\FormStateInterface;
use Drupal\vertex_ai_search\Plugin\VertexConfigurableJavaScriptPluginBase;

/**
 * Regex Validator Configurable JavaScript Plugin.
 *
 * @VertexConfigurableJavaScriptPlugin(
 *   id = "vertex_regex_validator",
 *   title = @Translation("Regex Validator"),
 * )
 */
class RegexValidator extends VertexConfigurableJavaScriptPluginBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['regex_patterns'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Regex Patterns'),
      '#default_value' => $this->configuration['regex_patterns'] ?? ($form_state->getValue('regex_patterns') ?? NULL),
      '#description' => $this->t('Enter one rule per line in the format: <code>pattern::message::severity</code>.<br>
        Severity levels: <strong>error</strong> (prevents submission), <strong>warning</strong> (shows a warning),
        <strong>info</strong> (shows an informational message).<br>
        By default, <code>exclude_regex.js</code> will validate input and display inline messages based on these rules.
        Developers can override this behavior by adding a custom <code>RegexValidationCheck</code> event listener to
        implement their own validation logic or UI.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function getJavaScriptLibrary() {
    return 'vertex_ai_search/exclude_regex';
  }

  /**
   * {@inheritdoc}
   */
  public function getJavaScriptSettings() {
    return $this->configuration['regex_patterns'];
  }

  /**
   * {@inheritdoc}
   */
  public function alterSearchForm(array &$form, FormStateInterface $form_state) {
    $form['#attached']['library'][] = $this->getJavaScriptLibrary();
    $form['#attached']['drupalSettings']['vertex_ai_search']['regex'] = $this->getJavaScriptSettings();
  }

}
