<?php

namespace Drupal\vertex_ai_search\Plugin;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\DependentPluginInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormInterface;

/**
 * Provides an interface for Vertex Configurable JavaScript plugins.
 *
 * This interface defines the methods required for plugins that can be
 * configured and that provide JavaScript functionality in the Vertex AI Search
 * module.
 *
 * @ingroup vertex_ai_search
 */
interface VertexConfigurableJavaScriptPluginInterface extends ConfigurableInterface, DependentPluginInterface, PluginFormInterface {

  /**
   * Builds the configuration form for the plugin.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   *
   * @return array
   *   The modified form structure.
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state);

  /**
   * Submits the configuration form for the plugin.
   *
   * @param array $form
   *   The form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state);

  /**
   * Returns the configuration for the plugin.
   *
   * @return array
   *   The configuration array for the plugin.
   */
  public function getConfiguration();

  /**
   * Sets the configuration for the plugin.
   *
   * @param array $configuration
   *   The configuration array to set.
   */
  public function setConfiguration(array $configuration);

  /**
   * Returns the library for the javascript plugin.
   *
   * @return array
   *   The javascript library.
   */
  public function getJavaScriptLibrary();

  /**
   * Returns the JavaScript settings for the plugin.
   *
   * @return array
   *   The JavaScript settings array for the plugin.
   */
  public function getJavaScriptSettings();

  /**
   * Alters the search form to include the plugin's JavaScript.
   *
   * This method should be called to ensure that the plugin's JavaScript is
   * attached to the search form.
   *
   * @param array $form
   *   The search form structure.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   */
  public function alterSearchForm(array &$form, FormStateInterface $form_state);

}
