# Video Embed Field Youku

这个模块为 Video Embed Field 模块提供优酷视频支持。

## 功能特性

- 支持优酷视频嵌入
- 自动获取视频标题、描述和缩略图
- API 响应缓存
- 安全的 API 密钥管理
- 完整的错误处理和日志记录

## 安装

1. 将模块文件放置到 `modules/custom/video_embed_youku` 目录
2. 在 Drupal 管理界面启用模块
3. 配置优酷 API 设置

## 配置

### 获取优酷 API 客户端 ID

1. 访问 [优酷开放平台](https://open.youku.com/)
2. 注册开发者账号并创建应用
3. 获取 API 客户端 ID

### 模块设置

1. 访问 **管理 > 配置 > 媒体 > Video Embed Youku** (`/admin/config/media/video-embed-youku`)
2. 输入您的优酷 API 客户端 ID
3. 设置缓存持续时间（默认 3600 秒）
4. 保存配置

## 使用

在内容类型中添加 Video Embed Field 字段，然后粘贴优酷视频 URL。支持的 URL 格式：

- `https://v.youku.com/v_show/id_XNDQ2NjQwMjQw.html`
- `http://v.youku.com/v_show/id_XNDQ2NjQwMjQw.html`

## 安全改进

此模块已修复以下安全问题：

- 移除硬编码的 API 密钥
- 使用安全的 HTTP 客户端
- 添加输入验证和错误处理
- 实现缓存机制以提高性能
- 完整的日志记录和用户反馈

## 依赖项

- Drupal 8+
- Video Embed Field 模块

## 技术细节

- 使用依赖注入模式
- 遵循 Drupal 编码标准
- 包含完整的 PHPDoc 注释
- 支持配置管理和缓存

## 故障排除

如果遇到问题：

1. 检查 API 客户端 ID 是否正确配置
2. 查看 Drupal 日志中的错误信息
3. 确保网络连接正常
4. 验证优酷 API 服务是否可用

## 许可证

GPL v2