<?php

/**
 * @file
 * Permission-related helper functions for VideoJS Mediablock module.
 */

/**
 * Helper function to check if a user has permission to use a specific field.
 */
function _videojs_mediablock_check_field_permission($field_name, $account = NULL) {
  if (!$account) {
    $account = \Drupal::currentUser();
  }

  $admin_access = $account->hasPermission('administer videojs mediablock');

  switch ($field_name) {
    case 'field_videojs_local_audio_file':
      return $admin_access || $account->hasPermission('use videojs local audio');

    case 'field_videojs_media_file':
      return $admin_access || $account->hasPermission('use videojs local video');

    case 'field_videojs_remote_audio_file':
      return $admin_access || $account->hasPermission('use videojs remote audio');

    case 'field_videojs_remote_media_file':
      return $admin_access || $account->hasPermission('use videojs remote video');

    case 'field_videojs_youtube':
      return $admin_access || $account->hasPermission('use videojs youtube');

    default:
      return $admin_access;
  }
}
