<?php

/**
 * @file
 * Field-related helper functions for VideoJS Mediablock module.
 */

use Drupal\Core\Entity\EntityInterface;

/**
 * Helper function to get all media fields that should be managed.
 */
function _videojs_mediablock_get_media_fields() {
  return [
    'field_videojs_local_audio_file',
    'field_videojs_media_file',
    'field_videojs_remote_audio_file',
    'field_videojs_remote_media_file',
    'field_videojs_youtube',
  ];
}

/**
 * Helper function to clear non-selected media fields.
 *
 * @param \Drupal\Core\Entity\EntityInterface $entity
 *   The entity to modify.
 * @param string|null $selected_field
 *   The field name that should be preserved. All other media fields will be
 *   cleared.
 */
function _videojs_mediablock_clear_unused_fields(EntityInterface $entity, $selected_field) {
  $fields_to_check = _videojs_mediablock_get_media_fields();

  foreach ($fields_to_check as $field) {
    if ($field !== $selected_field && $entity->hasField($field) && !$entity->get($field)->isEmpty()) {
      $entity->set($field, NULL);
    }
  }
}
