## Overview

The VideoJS Mediablock module is an ADA/508 compliant, Responsive media player
that works well with the Media and Media Library modules in Drupal
core. [VideoJS](https://videojs.com/) is a very mature, open-source video
library primarily sponsored by Brightcove,
with [a wealth of plugins](https://videojs.com/plugins/).

Without the use of a mediaplayer as this module provides, by default, visitors
to your website will experience audio/video media displayed using whatever
internet client-browser is in-use, and under its own negotiated terms. This
module provides Drupal site builders and developers complete control while
delivering ease-of-use to content managers.

## Features

- Compliant with the Americans with Disabilities Act (ADA) standards for video,
  by providing configurable, themable, and multilingual closed-captions support.
- The VideoJS Mediablock module creates a custom blocktype with three fields to
  input a Media file, an optional poster image, and an optional subtitle file.
- Responsive, with no need to input height or width values. Simply input a media
  source -- possibly YouTube.
- Support for
  Drupal's [Single Directory Component](https://www.drupal.org/docs/develop/theming-drupal/using-single-directory-components)
  theming.
- Remote hosting is supported as well as local server hosting.
- MP3 audio files are supported as well as MP4 videos.
- Videos hosted on YouTube are supported.
- **New**: Improved data handling via a simple AJAX interface.
- **New**: Granular permissions to restrict any of these Media fields
  - Locally hosted audio
  - Locally hosted video
  - Remotely hosted audio
  - Remotely hosted video
  - YouTube
- **New**: Multi-player support, in that only a single player on a page can play
  at any one time. Clicking any player makes it active and pauses all other
  players.
- **New**: [Hotkeys](https://github.com/ctd1500/videojs-hotkeys):
  - Space bar toggles play/pause.
  - Right and Left Arrow keys seek the video forwards and back.
  - Up and Down Arrow keys increase and decrease the volume.
  - M key toggles mute/unmute.
  - F key toggles fullscreen off and on.
  - Double-clicking with the mouse toggles fullscreen off and on.
  - Number keys from 0-9 skip to a percentage of the video. 0 is 0% and 9 is
    90%.
- Besides the default player
  theme, [four more are available](https://www.mux.com/blog/the-new-video-js-themes).
  And of course it is easy
  to [customize media player themes](https://videojs.com/guides/skins/).

  For
  example, [https://www.thrashermagazine.com](https://www.thrashermagazine.com)
  uses a custom media player theme for their older videos.
  Like [this one](https://www.thrashermagazine.com/articles/videos/skateline-06-11-2024/).
  Please note,
  *[https://www.thrashermagazine.com](https://www.thrashermagazine.com) is
  using [a completely different, commercial media player](https://jwplayer.com/)*,
  not this free, open-source Drupal VideoJS Mediablock module.
- Developed around the core Media and Media Library modules.

## Required modules

Drupal **core** modules: Media Library, Config, Field, Block Content,
Serialization

Drupal **contrib**
module: [File Upload Secure Validator](https://www.drupal.org/project/file_upload_secure_validator)

## Other Requirements

NPM must be installed on the server.

The php library `fileinfo` must be installed on the server.

Drupal 10.3 or higher is
required, [and this patch](https://git.drupalcode.org/project/drupal/-/merge_requests/3094.diff)
is required for Drupal versions 10.0 - 10.2. More information about the patched
issue is here:

- [Issue 3062376: Template suggestions for custom block view modes](https://www.drupal.org/project/drupal/issues/3062376#comment-14885212)

## Instructions

**Differences between Drupal 10 & Drupal 11**

Drupal 10.0, 10.1, and 10.2 must be patched or this module will not function.
Drupal 10.3 and Drupal 11 do not need to be patched.

Drupal 10 requires the Drupal core SDC (experimental) module be installed for
any custom theming. There is no SDC module in Drupal 11 because that code has
been implemented directly into core Drupal. Because the 2.1.x branch has been
developed for Drupal 11 the SDC requirement has been removed, *but must be
manually enabled on Drupal 10 websites*.

**Installation**

Upon installation, from within the module's root folder, you must install NPM
related libraries with the `npm install`, `npm clean install`, or `npm update`
commands. Over time, you'll need to keep these libraries up-to-date using NPM.

Navigate to `/admin/config/media/file_upload_secure_validator`. Copy the
following lines to ensure filetype upload security, adding them to the bottom of
the list:

```
video/quicktime,video/mp4,video/x-m4v,video/ogg,video/webm,video/x-flv,video/x-f4v
```

```
audio/x-aac,audio/x-flac,audio/x-mpeg,audio/mpeg,audio/mp4,audio/ogg,application/x-ogg,audio/vorbis,audio/x-wav
```

```
text/vtt,text/plain
```

**Usage**

Create a new custom VideoJS Mediablock at `/block/add/videojs_mediablock`. The
media field is required, while the poster and subtitle fields are optional.

Note: If you are using Drupal CMS, you might be accessing this module at
`/block/add.`

Drupal CMS has no content blocks by default, whereas Drupal core has a Basic
content block by default and this module forces users to choose between those
two options on the `/block/add` path in Drupal core.

New VideoJS Mediablocks will be listed at
`/admin/structure/block/block-content`.

Place your custom blocks anywhere at `/admin/structure/block` or use Layout
Builder.

## Theming VideoJS Mediablock with Single Directory Components

To custom theme the VideoJS Mediablock module (which uses Single Directory
Components) from your theme directory:

1. Create a directory structure in your theme that mirrors the module's
   components
2. Override specific component player files with your custom versions

### Basic Steps

1. In your theme directory, create a folder structure like:

   ```
   your-theme/
   └── components/
       └── videojs_mediablock/
           └── player/
   ```

2. Copy only the specific component player files you want to modify from the
   module to your theme

3. Make your customizations in these files

4. Drupal will automatically use your theme's versions of these components
   instead of the module's originals

This approach allows you to maintain clean separation between the module and
your custom theme while precisely targeting just the components you want to
change.

## Roadmap

- Version 1.0.x is deprecated.

- Version 2.0.x is now deprecated so I can focus on new development. It was
  refactored to include a better uninstaller, SDC support, and a development
  path forward.

- Version 2.1.x is no longer supported. Code to support audio and remote media
  file hosting, including YouTube is new. The user-interface to support these
  features has also been developed along with the requisite field logic and
  validation. [Click here to see an animation.](https://www.drupal.org/files/project-images/videojs_mediablock_edit1.gif)

- Version 2.2.x is the current development branch. Permissions for each Media
  field are now possible. Much development went into the content-edit form to
  improve data handling without breaking the AJAX interface. Now, only a single
  player can play at any one time on a page with multiple players. Support for
  Hotkeys has also recently been developed.

You can [buy me a coffee ☕](https://www.buymeacoffee.com/amstercad) if you're so
inclined -- I'll be grateful.
