<?php

/**
 * @file
 * Logging functions for the VideoJS Mediablock module.
 */

use Drupal\Core\Form\FormStateInterface;

/**
 * Implements hook_media_source_info_alter().
 */
function videojs_mediablock_media_source_info_alter(array &$sources) {
  // Log all available media sources for debugging.
  \Drupal::logger('videojs_mediablock')
    ->debug('Available media sources: @sources', [
      '@sources' => print_r(array_keys($sources), TRUE),
    ]);
}

/**
 * Implements hook_entity_type_alter().
 */
function videojs_mediablock_entity_type_alter(array &$entity_types) {
  if (isset($entity_types['media'])) {
    \Drupal::logger('videojs_mediablock')
      ->debug('Media entity type definition: @definition', [
        '@definition' => print_r($entity_types['media']->id(), TRUE),
      ]);
  }
}

/**
 * Implements hook_form_FORM_ID_alter() for media_library_add_form_upload.
 */
function videojs_mediablock_form_media_library_add_form_upload_alter(&$form, FormStateInterface $form_state, $form_id) {
  \Drupal::logger('videojs_mediablock')
    ->debug('Media library upload form alter called');

  // Get the media type from the form.
  $media_type = $form_state->get('media_type');
  if ($media_type) {
    \Drupal::logger('videojs_mediablock')
      ->debug('Media type in upload form: @type', [
        '@type' => $media_type->id(),
      ]);

    // Log the source field configuration.
    $source_field = $media_type->getSource()
      ->getConfiguration()['source_field'] ?? NULL;
    \Drupal::logger('videojs_mediablock')
      ->debug('Source field for media type @type: @field', [
        '@type' => $media_type->id(),
        '@field' => $source_field ?? 'NULL',
      ]);
  }
}

/**
 * Implements hook_form_FORM_ID_alter().
 */
function videojs_mediablock_form_media_library_add_form_alter(&$form, FormStateInterface $form_state, $form_id) {
  \Drupal::logger('videojs_mediablock')
    ->debug('Media library add form alter called for form ID: @form_id', ['@form_id' => $form_id]);

  // Log the available media types.
  $media_types = $form_state->get('media_types');
  if ($media_types) {
    foreach ($media_types as $media_type) {
      \Drupal::logger('videojs_mediablock')
        ->debug('Available media type: @type', [
          '@type' => $media_type->id(),
        ]);

      // Log the source field configuration.
      $source = $media_type->getSource();
      $source_config = $source->getConfiguration();
      \Drupal::logger('videojs_mediablock')
        ->debug('Source for media type @type: @source_plugin, config: @config', [
          '@type' => $media_type->id(),
          '@source_plugin' => $source->getPluginId(),
          '@config' => print_r($source_config, TRUE),
        ]);
    }
  }
}

/**
 * Implements hook_preprocess_HOOK() for media-library-wrapper.html.twig.
 */
function videojs_mediablock_preprocess_media_library_wrapper(&$variables) {
  \Drupal::logger('videojs_mediablock')
    ->debug('Preprocessing media library wrapper');
}

/**
 * Implements hook_media_library_info_alter().
 */
function videojs_mediablock_media_library_info_alter(array &$info) {
  \Drupal::logger('videojs_mediablock')->debug('Media library info: @info', [
    '@info' => print_r($info, TRUE),
  ]);
}
