/* global VidstackPlayer */
(function (Drupal) {
  Drupal.behaviors.vidstackPlayer = {
    attach(context, settings) {
      if (typeof VidstackPlayer === 'undefined') {
        document.querySelector('#vidstack-js').addEventListener("load", () => {
          Drupal.behaviors.vidstackPlayer.init(context, settings);
        });
      }
      else {
        Drupal.behaviors.vidstackPlayer.init(context, settings);
      }
    },
    init: function(context, settings) {
      once('vidstack', '.vidstack-player', context).forEach(
        (videoPlayerElement) => {
          if (typeof VidstackPlayer === 'undefined') {
            Drupal.throwError(
              'Vidstack Player JS library could not be loaded.',
            );
            return;
          }
          VidstackPlayer.create({
            target: videoPlayerElement,
            layout: new VidstackPlayer.Layout.Default(),
          });
        },
      );
    },
  };
})(Drupal);
