/**
 * @file
 * Defines Javascript behaviors for the vidstack_player_cookies module.
 */
(function (Drupal, $) {
  /**
   * Define defaults.
   */
  Drupal.behaviors.vidstackPlayerCookies = {
    consentGiven() {
      const scriptId = 'vidstack_player_script';
      const script = document.getElementById(scriptId);
      if (script && script.nodeName === 'SCRIPT') {
        const content = script.innerHTML;
        const newScript = document.createElement('script');
        const attributes = Array.from(script.attributes);
        attributes.forEach((attr) => {
          if (attr.nodeName !== 'type' && attr.nodeName !== 'id') {
            newScript.setAttribute(attr.nodeName, attr.nodeValue);
          }
        });
        newScript.innerHTML = content;
        script.parentNode.replaceChild(newScript, script);

        // Manually initialize the Vidstack Player script if required.
        setTimeout(function () {
          if (typeof Drupal?.behaviors?.vidstackPlayer?.attach === 'function') {
            Drupal.behaviors.vidstackPlayer.attach(document);
          }
        }, 2000);
      }
    },
    consentDenied(context) {
      $('video.vidstack-player', context).cookiesOverlay('vidstack_player');
    },
    attach(context) {
      const self = this;
      document.addEventListener('cookiesjsrUserConsent', function (event) {
        const service =
          typeof event.detail.services === 'object'
            ? event.detail.services
            : {};
        if (
          typeof service.vidstack_player !== 'undefined' &&
          service.vidstack_player
        ) {
          self.consentGiven(context);
        } else {
          self.consentDenied(context);
        }
      });
    },
  };
})(Drupal, jQuery);
