# View NID Field Sort Drupal Module

## Overview

**View NID Field Sort** is a Drupal module that extends the Views functionality by providing custom sorting and filtering options based on node IDs (NIDs). This module is useful for site builders and developers who need more granular control over how nodes are ordered or filtered in Views, especially when working with lists of content where node ID is a relevant attribute.

---

## Features

- **Custom Views Sort Handler:** Sort nodes in Views by their node ID (NID), either ascending or descending.
- **Custom Views Filter Handler:** Filter nodes in Views based on their node ID, allowing for inclusion or exclusion of specific nodes.
- **Seamless Views Integration:** Adds new options to the Views UI for sorting and filtering by NID.
- **Flexible Configuration:** Supports various comparison operators and sorting directions.

---

## Folder Structure

```
view_nid_field_sort/
├── README.txt
├── view_nid_field_sort.info.yml
├── view_nid_field_sort.module
└── src/
    └── Plugin/
        └── views/
            ├── filter/
            │   └── NidFieldSortFilter.php   # Custom filter for NID
            └── sort/
                └── NidFieldSort.php        # Custom sort for NID
```

---

## Main Functionalities

### 1. Custom Views Sort Handler

- **NidFieldSort.php:**  
  Implements a Views sort plugin that allows users to sort nodes by their node ID.  
  - Appears as a sort option in the Views UI.
  - Supports ascending and descending order.

### 2. Custom Views Filter Handler

- **NidFieldSortFilter.php:**  
  Implements a Views filter plugin for node ID.  
  - Allows filtering nodes by specific NIDs.
  - Supports comparison operators (equals, not equals, in, not in, etc.).
  - Useful for including or excluding nodes from a View based on their ID.

### 3. Views Integration

- When enabled, the module registers its sort and filter plugins with Views.
- Site builders can add these options to any View that displays nodes.

---

## Usage

### Sorting by Node ID in Views

1. Edit or create a View that displays nodes.
2. In the "Sort criteria" section, add "Node ID (NID)" as a sort option.
3. Choose ascending or descending order as needed.

### Filtering by Node ID in Views

1. Edit or create a View that displays nodes.
2. In the "Filter criteria" section, add "Node ID (NID)" as a filter.
3. Enter the desired node IDs and select the comparison operator.

---

## Requirements

- Drupal 9 or 10
- Views module enabled
- PHP 7.4+

---

## Extending

- Developers can extend the sort and filter plugins to support additional logic or integrate with other modules.
- Custom comparison operators or sorting logic can be added by subclassing the provided plugins.

---

## License

See `LICENSE.txt`.

---

## Support

For issues or feature requests, open an issue in your repository or contact the maintainer.
