(function (Drupal, once) {
  Drupal.behaviors.publishToggle = {
    attach: function (context, settings) {
      once('publish-toggle', '.publish-toggle-checkbox', context)
        .forEach(function (checkbox) {
          checkbox.addEventListener('change', function () {
            const nid = this.dataset.nid;

            fetch('/view-publish-toggle/ajax', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'X-CSRF-Token': drupalSettings.csrfToken || '',
              },
              body: `nid=${nid}`,
            })
              .then(res => res.json())
              .then(data => {
                if (data.status === 'success') {
                  const wrapper = this.closest('.publish-toggle-wrapper');
                  const marker = wrapper.querySelector('.marker');
                  marker.textContent = data.published ? 'Published' : 'Unpublished';
                  marker.classList.toggle('marker--published', data.published);
                  marker.classList.toggle('marker--unpublished', !data.published);
                } else {
                  alert('Error: ' + (data.error || 'unknown'));
                }
              })
              .catch((e) => alert('AJAX-Error ' + e));
          });
        });
    }
  };
})(Drupal, once);
