<?php

namespace Drupal\view_publish_toggle\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\node\Entity\Node;

class PublishToggleController extends ControllerBase {

  /**
   * AJAX-Callback for toggle published state.
   */
  public function toggle(Request $request) {
    $nid = $request->request->get('nid');
    $node = Node::load($nid);
    $user = $this->currentUser();

    \Drupal::logger('view_publish_toggle')
      ->debug('Publish toggle called: Node @nid, User @uid', [
        '@nid' => $nid,
        '@uid' => $user->id(),
      ]);

    if ($node && $node->access('update', $user) && $user->hasPermission('publish content toggle')) {
      $isPublished = $node->isPublished();

      if ($isPublished) {
        $node->setUnpublished();
      }
      else {
        $node->setPublished();
      }

      $node->save();

      \Drupal::logger('view_publish_toggle')
        ->debug('Node @nid new published state: @from to @to', [
          '@nid' => $nid,
          '@from' => $isPublished ? 'published' : 'unpublished',
          '@to' => $node->isPublished() ? 'published' : 'unpublished',
        ]);

      return new JsonResponse([
        'status' => 'success',
        'published' => $node->isPublished(),
        'nid' => $nid,
      ]);
    }

    return new JsonResponse(['error' => 'Access denied'], 403);
  }

}
