<?php

namespace Drupal\view_publish_toggle\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;

/**
 * @FieldFormatter(
 *   id = "publish_toggle_formatter",
 *   label = @Translation("Publish toggle formatter"),
 *   field_types = {"boolean"}
 * )
 */
class PublishToggleFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];
    $user = \Drupal::currentUser();

    foreach ($items as $delta => $item) {
      $node = $items->getEntity();

      if ($node->access('update', $user) && $user->hasPermission('publish content toggle')) {
        $published = (bool) $item->value;
        $status_class = $published ? 'marker--published' : 'marker--unpublished';
        $status_text = $published ? $this->t('Published') : $this->t('Unpublished');

        $elements[$delta] = [
          '#theme' => 'publish_toggle_formatter',
          '#nid' => $node->id(),
          '#published' => $published,
          '#status_class' => $status_class,
          '#status_text' => $status_text,
          '#attached' => [
            'library' => ['view_publish_toggle/publish-toggle'],
            'drupalSettings' => [
              'csrfToken' => \Drupal::service('csrf_token')->get('view_publish_toggle/ajax'),
            ],
          ],
        ];
      }
      else {
        $elements[$delta] = [
          '#markup' => $item->value ? $this->t('Published') : $this->t('Unpublished'),
        ];
      }
    }

    return $elements;
  }

}
