# View Publish Toggle

https://www.drupal.org/project/view_publish_toggle

This module provides a simple field formatter that allows content editors to
**toggle the published state of entities directly within a View**.

## Features

- Adds a "Publish toggle" field formatter for boolean fields (e.g., `status`).
- Allows enabling or disabling a node without leaving the View page.
- Works with Views exposed for administrative listings or custom dashboards.

## Installation

Install as usual via Composer:

```bash
    composer require drupal/view_publish_toggle
```

To enable it use the following or the UI:

```bash
    drush en view_publish_toggle
```

## Configuration

- Create or edit a View that lists content (e.g., a node listing).
- Add a Boolean field referencing the "Published" status.
- In the field’s Formatter settings, select “Publish toggle formatter”.
- Save the View.  
  → You can now toggle publish/unpublish directly from the View output.

## Example use case

Add this formatter to an administrative View for editors.  
They can quickly change publish states without opening each node individually.

## Requirements

- Drupal 10 or 11
- Core views module enabled
- No external dependencies
