<?php

namespace Drupal\Tests\view_unpublished_dynamic_permission\Functional;

use Drupal\Tests\node\Traits\ContentTypeCreationTrait;
use Drupal\user\Entity\Role;

/**
 * Tests unpublished nodes.
 *
 * @group view_unpublished_dynamic_permission
 */
class ViewUnpublishedDynamicPermissionNodeTest extends ViewUnpublishedDynamicPermissionTestBase {

  use ContentTypeCreationTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['node'];

  /**
   * Test view_unpublished_dynamic_permission with nodes.
   *
   * @throws \Behat\Mink\Exception\ExpectationException
   */
  public function testNodeAccess(): void {
    $this->createContentType(['type' => 'page']);
    $this->createNode(['type' => 'page', 'status' => FALSE]);

    $this->drupalGet('node/1');
    $this->assertSession()->statusCodeEquals(403);

    // Now grant new permission.
    $this->grantPermissions(Role::load('editor'), ['view any unpublished node:page']);

    $this->drupalGet('node/1');
    $this->assertSession()->statusCodeEquals(200);
  }

}
