<?php

namespace Drupal\Tests\view_unpublished_dynamic_permission\Functional;

use Drupal\Tests\taxonomy\Traits\TaxonomyTestTrait;
use Drupal\user\Entity\Role;

/**
 * Tests unpublished Taxonomy terms.
 *
 * @group view_unpublished_dynamic_permission
 */
class ViewUnpublishedDynamicPermissionTaxonomyTest extends ViewUnpublishedDynamicPermissionTestBase {

  use TaxonomyTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['taxonomy'];

  /**
   * Test view_unpublished_dynamic_permission with taxonomy.
   *
   * @throws \Behat\Mink\Exception\ExpectationException
   */
  public function testTaxonomyAccess(): void {
    $vocab = $this->createVocabulary(['vid' => 'test', 'name' => 'Test']);
    $this->createTerm($vocab, ['status' => FALSE]);

    $this->drupalGet('taxonomy/term/1');
    $this->assertSession()->statusCodeEquals(403);

    // Now grant new permission.
    $this->grantPermissions(Role::load('editor'), ['view any unpublished taxonomy_term']);

    $this->drupalGet('taxonomy/term/1');
    $this->assertSession()->statusCodeEquals(200);
  }

}
