<?php

namespace Drupal\Tests\view_unpublished_dynamic_permission\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\user\Traits\UserCreationTrait;
use Drupal\user\UserInterface;

/**
 * Base class for testing View Unpublished Dynamic Permissions.
 */
abstract class ViewUnpublishedDynamicPermissionTestBase extends BrowserTestBase {

  use UserCreationTrait;

  /**
   * Editor test role.
   *
   * @var \Drupal\user\UserInterface
   */
  protected UserInterface $editor;

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['view_unpublished_dynamic_permission'];

  /**
   * Shared permissions for all tests.
   *
   * @var array
   *   A list of permissions.
   */
  protected array $permissions = ['access administration pages', 'view the administration theme'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  protected function setUp(): void {
    parent::setUp();

    $this->drupalCreateRole([], 'editor', 'Editor');
    $this->editor = $this->drupalCreateUser($this->permissions);
    $this->editor->addRole('editor')->save();
    $this->drupalLogin($this->editor);
  }

}
