<?php

declare(strict_types = 1);

/**
 * Copyright (C) 2025 PRONOVIX GROUP.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 */

namespace Drupal\view_usernames_mail_plugin_test\Plugin\Mail;

use Drupal\Core\Mail\MailInterface;

/**
 * Mock mail plugin by annotation definition.
 *
 * @Mail(
 *   id = "view_usernames_mail_plugin_test_mail_plugin_via_annotation",
 *   label = @Translation("Dummy mail plugin defined via annotation"),
 * )
 */
final class DummyMailPluginDiscoveredFromAnnotation implements MailInterface {

  /**
   * {@inheritdoc}
   */
  public function format(array $message): array {
    return $message;
  }

  /**
   * {@inheritdoc}
   */
  public function mail(array $message): bool {
    return TRUE;
  }

}
