<?php

declare(strict_types = 1);

/**
 * Copyright (C) 2025 PRONOVIX GROUP.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 */

namespace Drupal\Tests\view_usernames\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\view_usernames\Mail\MailManagerDecorator;

/**
 * Covers MailManagerDecorator with tests.
 *
 * @covers \Drupal\view_usernames\Mail\MailManagerDecorator
 */
final class MailPluginManagerDecoratorTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'view_usernames_mail_plugin_test',
  ];

  /**
   * Test the decorator discovers the same plugins as the original manager.
   */
  public function testDiscoversTheSamePluginAsTheOriginalManager(): void {
    $before_vu_mail_plugin_ids = array_keys($this->container->get('plugin.manager.mail')->getDefinitions());
    $this->assertNotEmpty($before_vu_mail_plugin_ids, 'There is at least one mail plugin registered.');
    $this->assertContains('php_mail', $before_vu_mail_plugin_ids, 'The "php_mail" plugin is registered.');
    $this->assertContains('view_usernames_mail_plugin_test_mail_plugin_via_annotation', $before_vu_mail_plugin_ids, 'The "view_usernames_mail_plugin_test_mail_plugin_via_annotation" plugin is registered.');
    $this->assertContains('view_usernames_mail_plugin_test_mail_plugin_via_attribute', $before_vu_mail_plugin_ids, 'The "view_usernames_mail_plugin_test_mail_plugin_via_attribute" plugin is registered.');

    $this->container->get('module_installer')->install(['view_usernames']);

    // @phpstan-ignore staticMethod.impossibleType
    self::assertInstanceOf(MailManagerDecorator::class, $this->container->get('plugin.manager.mail'), 'The decorator is active after the module is enabled.');
    $after_vu_mail_plugin_ids = array_keys($this->container->get('plugin.manager.mail')->getDefinitions());
    $this->assertEquals($before_vu_mail_plugin_ids, $after_vu_mail_plugin_ids, 'The same set of mail plugins are discovered by the decorated manager too.');
  }

}
