# View Usernames: Node Author

This module introduces a "view username" access decider that grants access to view a user's username if that user is
the author of a node to which the current (or acting) user has **view** access. For more details, see the
[Known limitations](#known-limitations) section.

> **Note**: This module **MUST ONLY** be enabled if the site owner confirms that every node author's username can become
> visible based on the logic described above.

## TODOs

- Validate and finalize support for node revisions if needed. For example, a user might be able to view the username
  of another user because that user is the author of a non-default revision of a node.
  - This should be handled by a dedicated decider that runs after the current node access-based decider, but only if
    necessary, because this lookup can be very expensive.

## Known limitations

- Currently, only the "view" entity access for nodes is checked to decide whether a user can view another user's username.
  This limitation is set by default for performance reasons, as checking "view," "update," and "delete" access
  simultaneously could be expensive. Additionally, it might be unnecessary to expose an author's username to users
  who only have "update" or "delete" access to a node. If this feature is needed, a new instance of the
  `\Drupal\view_usernames_node_author\NodeAuthorViewUsernameAccessDecider` service can be registered to override the
  default entity operation used by the service via the
  `\Drupal\view_usernames_node_author\NodeAuthorViewUsernameAccessDecider::setEntityOperation()` method.

- The Internal Page Cache (_page_cache_) module does not support cache context-based "invalidation" of cached requests.
  When a user's access to a node changes via `hook_node_access_grants()`, previously cached results **DO NOT** get
  invalidated for non-logged-in users (since the Internal Page Cache is only active for non-logged-in users). However,
  the Dynamic Page Cache (_dynamic_page_cache_) module works as expected for authenticated users. See
  [cache context is being ignored](https://github.com/drupal/core/blob/e933fc86ecd6747832ed463740f7c8ca09247d0e/modules/page_cache/src/StackMiddleware/PageCache.php#L280-L283).
