(function (Drupal, once) {

  Drupal.behaviors.ViewerAccordion = {
    attach: function (context, settings) {
      once('viewer-accordion', '.viewer-accordion-wrapper', context).forEach(function (wrapper) {

        const toggles = wrapper.querySelectorAll('.toggle');
        toggles.forEach(function (toggle) {
          toggle.addEventListener('click', function (e) {
            e.preventDefault();
            const inner = this.nextElementSibling;

            if (inner.classList.contains('show')) {
              inner.classList.remove('show');
              this.classList.remove('active');
              slideUp(inner, 350);
            }
            else {
              // Close all other accordion items
              const parent = this.parentElement.parentElement;
              parent.querySelectorAll('.toggle').forEach(function (t) {
                t.classList.remove('active');
              });
              parent.querySelectorAll('li .inner').forEach(function (i) {
                i.classList.remove('show');
                slideUp(i, 350);
              });

              // Open clicked item
              inner.classList.add('show');
              this.classList.add('active');
              slideDown(inner, 350);
            }
          });
        });

        // Trigger click on active toggle
        const activeToggle = wrapper.querySelector('.toggle.is-active');
        if (activeToggle) {
          activeToggle.click();
        }
      });
    }
  };

  /**
   * Slide up animation.
   */
  function slideUp(element, duration) {
    element.style.transitionProperty = 'height, margin, padding';
    element.style.transitionDuration = duration + 'ms';
    element.style.boxSizing = 'border-box';
    element.style.height = element.offsetHeight + 'px';
    element.offsetHeight; // Force reflow
    element.style.overflow = 'hidden';
    element.style.height = 0;
    element.style.paddingTop = 0;
    element.style.paddingBottom = 0;
    element.style.marginTop = 0;
    element.style.marginBottom = 0;
    setTimeout(function () {
      element.style.display = 'none';
      element.style.removeProperty('height');
      element.style.removeProperty('padding-top');
      element.style.removeProperty('padding-bottom');
      element.style.removeProperty('margin-top');
      element.style.removeProperty('margin-bottom');
      element.style.removeProperty('overflow');
      element.style.removeProperty('transition-duration');
      element.style.removeProperty('transition-property');
    }, duration);
  }

  /**
   * Slide down animation.
   */
  function slideDown(element, duration) {
    element.style.removeProperty('display');
    let display = window.getComputedStyle(element).display;
    if (display === 'none') {
      display = 'block';
    }
    element.style.display = display;
    const height = element.offsetHeight;
    element.style.overflow = 'hidden';
    element.style.height = 0;
    element.style.paddingTop = 0;
    element.style.paddingBottom = 0;
    element.style.marginTop = 0;
    element.style.marginBottom = 0;
    element.offsetHeight; // Force reflow
    element.style.boxSizing = 'border-box';
    element.style.transitionProperty = 'height, margin, padding';
    element.style.transitionDuration = duration + 'ms';
    element.style.height = height + 'px';
    element.style.removeProperty('padding-top');
    element.style.removeProperty('padding-bottom');
    element.style.removeProperty('margin-top');
    element.style.removeProperty('margin-bottom');
    setTimeout(function () {
      element.style.removeProperty('height');
      element.style.removeProperty('overflow');
      element.style.removeProperty('transition-duration');
      element.style.removeProperty('transition-property');
    }, duration);
  }

})(Drupal, once);
