(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerApexChartsCandlestick = {
    attach: function (context, settings) {
      once('viewer-apexcharts-candlestick', '.viewer-apexcharts-candlestick-wrapper', context).forEach(function (wrapper) {
        const type = wrapper.dataset.type;
        const element = wrapper.querySelector('.apexcharts-chart');
        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          const headers = response.data.headers;
          const rows = response.data.rows;
          const settings = response.settings;
          const configuration = response.configuration;
          const series = [];

          rows.forEach(function(row, i) {
            series.push({
              x: new Date(parseInt(row[configuration['datasets'][0].timestamp])),
              y: [
                parseFloat(row[parseInt(configuration['datasets'][0].open)]),
                parseFloat(row[parseInt(configuration['datasets'][0].high)]),
                parseFloat(row[parseInt(configuration['datasets'][0].low)]),
                parseFloat(row[parseInt(configuration['datasets'][0].close)])
              ]
            });
          });

          const options = {
            series: [{
              data: series
            }],
            chart: {
              type: 'candlestick',
              toolbar: {
                show: true,
                tools: {
                  download: false, selection: true, zoom: true, zoomin: true, zoomout: true, pan: true, customIcons: []
                },
              },
              zoom: {
                enabled: true
              }
            },
            title: {
              text: settings['chart_title'],
              align: settings['chart_title_position']
            },
            subtitle: {
              text: settings['chart_subtitle'],
              align: settings['chart_subtitle_position']
            },
            xaxis: {
              type: 'datetime'
            },
            yaxis: {
              tooltip: {
                enabled: true
              }
            }
          };

          const chart = new ApexCharts(element, options);
          chart.render();

        });
      });
    }
  };

})(Drupal, once);
