(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerApexChartsLine = {
    attach: function (context, settings) {
      once('viewer-apexcharts-line', '.viewer-apexcharts-line-wrapper', context).forEach(function (wrapper) {
        const element = wrapper.querySelector('.apexcharts-chart');
        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          const headers = response.data.headers;
          const rows = response.data.rows;
          const settings = response.settings;
          const configuration = response.configuration;
          const labels = [];
          const colors = [];
          const series = [];
          rows.forEach(function(row, i) {
            labels.push(row[settings.labels]);
          });
          for (const item of Object.values(configuration['datasets'])) {
            const items = [];
            rows.forEach(function(row, j) {
              items.push(row[item.dataset]);
            });
            colors.push(item.color);
            series.push({
              data: items,
              name: item.label ? item.label : headers[item.dataset],
            });
          }

          const options = {
            series: series,
            chart: {
              type: settings['chart_type'],
              toolbar: {
                show: false,
                tools: {
                  download: false, selection: false, zoom: false, zoomin: false, zoomout: false, pan: false, customIcons: []
                },
              },
              zoom: {
                enabled: false
              }
            },
            dataLabels: {
              enabled: false
            },
            stroke: {
              curve: settings['chart_curve']
            },
            title: {
              text: settings['chart_title'],
              align: settings['chart_title_position']
            },
            subtitle: {
              text: settings['chart_subtitle'],
              align: settings['chart_subtitle_position']
            },
            colors: colors,
            xaxis: {
              categories: labels,
            }
          };

          const chart = new ApexCharts(element, options);
          chart.render();

        });
      });
    }
  };

})(Drupal, once);
