(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerApexChartsMixed = {
    attach: function (context, settings) {
      once('viewer-apexcharts-mixed', '.viewer-apexcharts-mixed-wrapper', context).forEach(function (wrapper) {
        const element = wrapper.querySelector('.apexcharts-chart');
        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          const headers = response.data.headers;
          const rows = response.data.rows;
          const settings = response.settings;
          const configuration = response.configuration;
          const labels = [];
          const colors = [];
          const series = [];
          rows.forEach(function(row, i) {
            labels.push(row[settings.labels]);
          });
          for (const item of Object.values(configuration['datasets'])) {
            const items = [];
            rows.forEach(function(row, j) {
              items.push(row[item.dataset]);
            });
            colors.push(item.color);
            series.push({
              data: items,
              name: item.label ? item.label : headers[item.dataset],
              type: item.type
            });
          }

          const options = {
            series: series,
            chart: {
              toolbar: {
                show: false,
                tools: {
                  download: false, selection: false, zoom: false, zoomin: false, zoomout: false, pan: false, customIcons: []
                },
              },
              zoom: {
                enabled: false
              }
            },
            dataLabels: {
              enabled: false
            },
            stroke: {
              width: [0, 2, 5],
              curve: 'smooth'
            },
            plotOptions: {
              bar: {
                columnWidth: '50%'
              }
            },
            fill: {
              gradient: {
                inverseColors: false,
                shade: 'light',
                type: "vertical",
                opacityFrom: 0.85,
                opacityTo: 0.55
              }
            },
            title: {
              text: settings['chart_title'],
              align: settings['chart_title_position']
            },
            subtitle: {
              text: settings['chart_subtitle'],
              align: settings['chart_subtitle_position']
            },
            colors: colors,
            xaxis: {
              categories: labels,
            }
          };

          const chart = new ApexCharts(element, options);
          chart.render();

        });
      });
    }
  };

})(Drupal, once);
