(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerApexChartsPieDoughnut = {
    attach: function (context, settings) {
      once('viewer-apexcharts-piedoughnut', '.viewer-apexcharts-piedoughnut-wrapper', context).forEach(function (wrapper) {
        const type = wrapper.dataset.type;
        const element = wrapper.querySelector('.apexcharts-chart');
        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          const headers = response.data.headers;
          const rows = response.data.rows;
          const settings = response.settings;
          const configuration = response.configuration;
          const labels = [];
          const indexes = [];
          const colors = [];

          let index = 0;
          for (const item of Object.values(configuration['datasets'])) {
            labels.push(item.label ? item.label : headers[item.dataset]);
            indexes.push(parseInt(item.dataset));
            colors.push(item.color);
          }
          // Initializing an empty matrix.
          const aggregated = new Array(rows.length).fill(0).map(() => new Array(labels.length).fill(0));
          for (let i = 0; i < rows.length; i++) {
            let k = 0;
            for (let j = 0; j < indexes.length; j++) {
              if (indexes[j] !== undefined) {
                aggregated[i][k] = parseFloat(rows[i][indexes[j]]);
                k++;
              }
            }
          }
          // Sum columns.
          const items = aggregated.reduce(function (r, a) {
            a.forEach(function (b, i) {
              r[i] = (r[i] || 0) + b;
            });
            return r;
          }, []);

          const options = {
            series: items,
            chart: {
              type: type,
              toolbar: {
                show: false,
                tools: {
                  download: false, selection: false, zoom: false, zoomin: false, zoomout: false, pan: false, customIcons: []
                },
              },
              zoom: {
                enabled: false
              }
            },
            labels: labels,
            dataLabels: {
              enabled: true
            },
            fill: {
              gradient: {
                inverseColors: false,
                shade: 'light',
                type: "vertical",
                opacityFrom: 0.85,
                opacityTo: 0.55
              }
            },
            title: {
              text: settings['chart_title'],
              align: settings['chart_title_position']
            },
            subtitle: {
              text: settings['chart_subtitle'],
              align: settings['chart_subtitle_position']
            },
            colors: colors
          };

          const chart = new ApexCharts(element, options);
          chart.render();

        });
      });
    }
  };

})(Drupal, once);
