(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerApexChartsTreemap = {
    attach: function (context, settings) {
      once('viewer-apexcharts-treemap', '.viewer-apexcharts-treemap-wrapper', context).forEach(function (wrapper) {
        const element = wrapper.querySelector('.apexcharts-chart');
        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          const headers = response.data.headers;
          const rows = response.data.rows;
          const settings = response.settings;
          const configuration = response.configuration;
          const colors = [];
          const series = [];
          for (const item of Object.values(configuration['datasets'])) {
            const labels = [];
            const items = [];
            rows.forEach(function(row, i) {
              items.push({
                x: row[item.labels],
                y: item.data_type == 'integer' ? parseInt(row[item.values].replace(/,/g, '')) : parseFloat(row[item.values].replace(/,/g, ''))
              });
            });
            colors.push(item.color);
            series.push({
              data: items,
              name: item.label ? item.label : headers[item.dataset],
            });
          }

          const options = {
            series: series,
            chart: {
              type: 'treemap',
              toolbar: {
                show: false,
                tools: {
                  download: false, selection: false, zoom: false, zoomin: false, zoomout: false, pan: false, customIcons: []
                },
              },
              zoom: {
                enabled: false
              }
            },
            title: {
              text: settings['chart_title'],
              align: settings['chart_title_position']
            },
            subtitle: {
              text: settings['chart_subtitle'],
              align: settings['chart_subtitle_position']
            },
            colors: colors
          };

          const chart = new ApexCharts(element, options);
          chart.render();

        });
      });
    }
  };

})(Drupal, once);
