(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerMixedCharts = {
    attach: function (context, settings) {
      once('viewer-mixed', '.viewer-mixed-wrapper', context).forEach(function (wrapper) {
        const type = wrapper.dataset.type;
        const chart = wrapper.querySelector('canvas');
        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          const headers = response.data.headers;
          const rows = response.data.rows;
          const settings = response.settings;
          const configuration = response.configuration;
          const labels = [];
          const datasets = [];
          rows.forEach(function(row, i) {
            labels.push(row[settings.labels]);
          });
          for (const item of Object.values(configuration['datasets'])) {
            const items = [];
            rows.forEach(function(row, j) {
              items.push(row[item.dataset]);
            });
            datasets.push({
              data: items,
              label: item.label ? item.label : headers[item.dataset],
              borderColor: item.color,
              backgroundColor: item.color,
              type: item.type,
              order: item.weight,
              fill: false
            });
          }

          const options = {
            plugins: {
              title: {
                display: true,
                text: Drupal.t(settings['chart_title']),
                align: settings['chart_title_position'] ? settings['chart_title_position'] : 'center',
              },
              subtitle: {
                display: true,
                text: Drupal.t(settings['chart_subtitle']),
                align: settings['chart_subtitle_position'] ? settings['chart_subtitle_position'] : 'center',
              }
            }
          };

          new Chart(chart, {
            type: type,
            data: {labels: labels, datasets: datasets},
            options: options
          });

        });
      });
    }
  };

})(Drupal, once);
