(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerPieDoughnut = {
    attach: function (context, settings) {
      once('viewer-piedoughnut', '.viewer-piedoughnut-wrapper', context).forEach(function (wrapper) {
        const type = wrapper.dataset.type;
        const chart = wrapper.querySelector('canvas');
        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          const headers = response.data.headers;
          const rows = response.data.rows;
          const settings = response.settings;
          const configuration = response.configuration;
          const labels = [];
          const datasets = [];
          const indexes = [];
          const bgcolors = [];
          if (settings.aggregate) {
            let index = 0;
            for (const item of Object.values(configuration['datasets'])) {
              labels.push(item.label ? item.label : headers[item.dataset]);
              indexes.push(parseInt(item.dataset));
              bgcolors.push(item.color);
            }
            // Initializing an empty matrix.
            const aggregated = new Array(rows.length).fill(0).map(() => new Array(labels.length).fill(0));
            for (let i = 0; i < rows.length; i++) {
              let k = 0;
              for (let j = 0; j < indexes.length; j++) {
                if (indexes[j] !== undefined) {
                  aggregated[i][k] = parseFloat(rows[i][indexes[j]]);
                  k++;
                }
              }
            }
            // Sum columns.
            const items = aggregated.reduce(function (r, a) {
              a.forEach(function (b, i) {
                r[i] = (r[i] || 0) + b;
              });
              return r;
            }, []);
            datasets.push({
              data: items,
              label: labels,
              backgroundColor: bgcolors,
              fill: false
            });
          }
          else {
            rows.forEach(function(row, i) {
              const randomColor = Math.floor(Math.random() * 16777215).toString(16);
              labels.push(row[settings.labels]);
              bgcolors.push('#' + randomColor);
            });
            for (const item of Object.values(configuration['datasets'])) {
              const items = [];
              rows.forEach(function(row, j) {
                items.push(row[item.dataset]);
              });
              datasets.push({
                data: items,
                label: headers[item.dataset],
                backgroundColor: bgcolors,
                fill: false
              });
            }
          }

          const options = {
            plugins: {
              title: {
                display: true,
                text: Drupal.t(settings['chart_title']),
                align: settings['chart_title_position'] ? settings['chart_title_position'] : 'center',
              },
              subtitle: {
                display: true,
                text: Drupal.t(settings['chart_subtitle']),
                align: settings['chart_subtitle_position'] ? settings['chart_subtitle_position'] : 'center',
              }
            }
          };

          new Chart(chart, {
            type: type,
            data: {labels: labels, datasets: datasets},
            options: options
          });

        });
      });
    }
  };

})(Drupal, once);
