(function (Drupal, once) {

  Drupal.behaviors.ViewerDatatables = {
    attach: function (context, settings) {
      once('viewer-datatables', '.viewer-datatables-wrapper', context).forEach(function (wrapper) {
        const table = wrapper.querySelector('table');
        const uuid = wrapper.dataset.viewer;

        // Show loader
        const loaderMarkup = '<div class="viewer-loader"><div class="overlay"></div>'
          + '<img src="' + drupalSettings.viewer.path + '/assets/loader.svg" border="0" />'
          + '<div class="loading-taking-time"></div></div>';
        wrapper.insertAdjacentHTML('beforeend', loaderMarkup);
        const loader = wrapper.querySelector('.viewer-loader');

        setTimeout(function() {
          const loadingText = wrapper.querySelector('.loading-taking-time');
          if (loadingText) {
            loadingText.innerHTML = 'Loading is taking longer than expected...';
          }
        }, 15000);

        // Fetch data
        const baseUrl = window.location.origin + drupalSettings.path.baseUrl;
        fetch(baseUrl + 'get/viewer/' + uuid + '?_format=json')
          .then(function(response) {
            return response.json();
          })
          .then(function(response) {
            const headers = [];
            if (response.data.headers !== undefined) {
              response.data.headers.forEach(function(header) {
                headers.push({title: header});
              });
            }

            // DataTables 2.x vanilla JS initialization
            new DataTable(table, {
              data: response.data.rows,
              columns: headers,
              language: {
                info: Drupal.t('Showing page _PAGE_ of _PAGES_'),
                infoEmpty: '',
                emptyTable: Drupal.t('No data to display'),
                lengthMenu: Drupal.t('Show _MENU_ records'),
                paginate: {
                  next: Drupal.t('Next'),
                  previous: Drupal.t('Previous')
                }
              }
            });

            // Hide loader
            loader.classList.add('hidden');

            // Make hidden elements visible
            wrapper.querySelectorAll('.viewer-hidden').forEach(function(el) {
              el.classList.remove('viewer-hidden');
            });
          });
      });
    }
  };

})(Drupal, once);
