(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerFullcalendar = {
    attach: function (context, settings) {
      once('viewer-fullcalendar', '.viewer-fullcalendar-wrapper', context).forEach(function (wrapper) {
        const element = wrapper.querySelector('.fullcalendar-element');
        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          const settings = response.settings;
          const events = response.data.events;
          const calendar = new FullCalendar.Calendar(element, {
            headerToolbar: {
              left: 'prev,next today',
              center: 'title',
              right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
            },
            initialDate: settings.initial_date,
            editable: false,
            navLinks: true, // can click day/week names to navigate views
            dayMaxEvents: true, // allow "more" link when too many events
            events: events
          });
          if (settings.height) {
            calendar.setOption('height', parseInt(settings.height));
          }
          calendar.render();
        });
      });
    }
  };

})(Drupal, once);
