(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerPdfJs = {
    attach: function (context, settings) {
      once('viewer-pdfjs', '.viewer-pdfjs-wrapper', context).forEach(function (wrapper) {
        const element = wrapper.querySelector('.pdfjs');
        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          if (response.data.file_path !== undefined) {
            const options = {
              forceIframe: true,
            };
            PDFObject.embed(response.data.file_path, element, options);
          }
          else {
            element.textContent = Drupal.t('PDF File not found');
          }
        });
      });
    }
  };

})(Drupal, once);
