(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerSpreadsheet = {
    attach: function (context, settings) {
      once('viewer-spreadsheet', '.viewer-spreadsheet-wrapper', context).forEach(function (wrapper) {
        const itemsPerLoad = parseInt(wrapper.dataset.itemsPerLoad) || 0;
        const loadMore = wrapper.querySelector('.viewer-load-more');
        let loadMoreCurrent = 0;
        let totalItemsLoaded = 0;
        let totalItems = 0;

        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {

          // Change tab class and display content
          const tabLinks = wrapper.querySelectorAll('.tabs__tab.worksheets a');
          tabLinks.forEach(function (link) {
            link.addEventListener('click', function (event) {
              event.preventDefault();
              const tabsWrapper = this.parentElement.closest('.tabs-wrapper');
              tabsWrapper.querySelectorAll('.is-active').forEach(function (el) {
                el.classList.remove('is-active');
              });
              this.parentElement.classList.add('is-active');
              this.classList.add('is-active');
              wrapper.querySelectorAll('.viewer-tabs-contents.worksheets .viewer-tabs-content').forEach(function (content) {
                content.style.display = 'none';
              });
              wrapper.querySelectorAll('.viewer-tabs-contents.worksheets .viewer-table').forEach(function (table) {
                table.style.width = '100%';
              });
              const targetId = this.getAttribute('href');
              if (targetId) {
                const targetContent = document.getElementById(targetId.replace('#', ''));
                if (targetContent) {
                  targetContent.style.display = '';
                }
              }
            });
          });
          // Trigger click on first tab
          if (tabLinks.length > 0) {
            tabLinks[0].click();
          }

          wrapper.querySelectorAll('table').forEach(function (table) {
            const worksheetId = table.dataset.worksheetId;

            // Load and build table headers.
            if (response.data.headers[worksheetId] !== undefined) {
              const thead = table.querySelector('thead');
              response.data.headers[worksheetId].forEach(function(header) {
                const th = document.createElement('th');
                th.textContent = header;
                thead.appendChild(th);
              });
            }
            // Load and build table rows.
            if (response.data.rows[worksheetId] !== undefined) {
              totalItems = response.data.rows[worksheetId].length;
              loadMore.classList.remove('hidden');
              if (itemsPerLoad > 0) {
                // Initial load.
                response.data.rows[worksheetId].forEach(function(row, i) {
                  if (itemsPerLoad > i) {
                    buildRow(table, row, i);
                    totalItemsLoaded++;
                  }
                });
              }
              else {
                // Load all if no items per load is specified.
                response.data.rows[worksheetId].forEach(function(row, i) {
                  buildRow(table, row, i);
                  totalItemsLoaded++;
                });
              }
            }
            // When all items are loaded on the page we need to hide the Load More button.
            if (totalItemsLoaded == totalItems) {
              loadMore.classList.add('hidden');
            }
            // Show more elements based on already loaded JSON.
            loadMore.addEventListener('click', function(e) {
              e.preventDefault();
              loadMoreCurrent = loadMoreCurrent + itemsPerLoad;
              let loadedCount = 0;
              // Loading more on Load More click.
              response.data.rows[worksheetId].forEach(function(row, i) {
                if (itemsPerLoad > loadedCount && i >= loadMoreCurrent) {
                  buildRow(table, row, i);
                  loadedCount++;
                  totalItemsLoaded++;
                }
              });
              buildPeityCharts();
              // When all items are loaded on the page we need to hide the Load More button.
              if (totalItemsLoaded == totalItems) {
                loadMore.classList.add('hidden');
              }
              // Scrolling to the bottom of the loaded container.
              const loadMoreContainer = wrapper.querySelector('.viewer-table-load-more');
              if (loadMoreContainer) {
                loadMoreContainer.scrollIntoView({ behavior: 'smooth' });
              }
            });

            buildPeityCharts();

          });
        });
      });
    }
  };

  /**
   * Find and build Peity charts in cells.
   */
  function buildPeityCharts() {
    if (typeof peity !== 'undefined') {
      document.querySelectorAll('.peity-cell-chart').forEach(function(element) {
        peity(element, element.dataset.type);
      });
    }
  }

  /**
   * Building table rows.
   */
  function buildRow(table, row, i) {
    const tr = document.createElement('tr');
    tr.className = (i % 2 === 0) ? 'even' : 'odd';
    row.forEach(function(cell) {
      const td = document.createElement('td');
      if (cell !== null) {
        td.innerHTML = cell;
      }
      tr.appendChild(td);
    });
    table.querySelector('tbody').appendChild(tr);
  }

})(Drupal, once);
