(function (Drupal, once) {

  const viewer = new Viewer();

  Drupal.behaviors.ViewerTables = {
    attach: function (context, settings) {
      once('viewer-table', '.viewer-table-wrapper', context).forEach(function (wrapper) {
        const table = wrapper.querySelector('table');
        const itemsPerLoad = parseInt(wrapper.dataset.itemsPerLoad) || 0;
        const loadMore = wrapper.querySelector('.viewer-load-more');
        let loadMoreCurrent = 0;
        let totalItemsLoaded = 0;
        let totalItems = 0;

        viewer.load(wrapper.dataset.viewer, wrapper, function(response) {
          // Load and build table headers.
          if (response.data.headers !== undefined) {
            const thead = table.querySelector('thead');
            response.data.headers.forEach(function(header) {
              const th = document.createElement('th');
              th.textContent = header;
              thead.appendChild(th);
            });
          }
          // Load and build table rows.
          if (response.data.rows !== undefined) {
            totalItems = response.data.rows.length;
            loadMore.classList.remove('hidden');
            if (itemsPerLoad > 0) {
              // Initial load.
              response.data.rows.forEach(function(row, i) {
                if (itemsPerLoad > i) {
                  buildRow(table, row, i);
                  totalItemsLoaded++;
                }
              });
            }
            else {
              // Load all if no items per load is specified.
              response.data.rows.forEach(function(row, i) {
                buildRow(table, row, i);
                totalItemsLoaded++;
              });
            }
          }
          // When all items are loaded on the page we need to hide the Load More button.
          if (totalItemsLoaded == totalItems) {
            loadMore.classList.add('hidden');
          }
          // Show more elements based on already loaded JSON.
          loadMore.addEventListener('click', function(e) {
            e.preventDefault();
            loadMoreCurrent = loadMoreCurrent + itemsPerLoad;
            let loadedCount = 0;
            // Loading more on Load More click.
            response.data.rows.forEach(function(row, i) {
              if (itemsPerLoad > loadedCount && i >= loadMoreCurrent) {
                buildRow(table, row, i);
                loadedCount++;
                totalItemsLoaded++;
              }
            });
            buildPeityCharts();
            // When all items are loaded on the page we need to hide the Load More button.
            if (totalItemsLoaded == totalItems) {
              loadMore.classList.add('hidden');
            }
            // Scrolling to the bottom of the loaded container.
            const loadMoreContainer = wrapper.querySelector('.viewer-table-load-more');
            if (loadMoreContainer) {
              loadMoreContainer.scrollIntoView({ behavior: 'smooth' });
            }
          });

          buildPeityCharts();
        });
      });
    }
  };

  /**
   * Find and build Peity charts in cells.
   */
  function buildPeityCharts() {
    if (typeof peity !== 'undefined') {
      document.querySelectorAll('.peity-cell-chart').forEach(function(element) {
        peity(element, element.dataset.type);
      });
    }
  }

  /**
   * Building table rows.
   */
  function buildRow(table, row, i) {
    const tr = document.createElement('tr');
    tr.className = (i % 2 === 0) ? 'even' : 'odd';
    row.forEach(function(cell) {
      const td = document.createElement('td');
      if (cell !== null) {
        td.innerHTML = cell;
      }
      tr.appendChild(td);
    });
    table.querySelector('tbody').appendChild(tr);
  }

})(Drupal, once);
