(function (Drupal, once) {

  Drupal.behaviors.ViewerTabsAdmin = {
    attach: function (context, settings) {
      once('viewer-tabs-admin', "input[name^='tabs'][name$='[default]']", context).forEach(function (checkbox) {
        checkbox.addEventListener('click', function (e) {
          // Uncheck all other default checkboxes
          document.querySelectorAll("input[name^='tabs'][name$='[default]']").forEach(function (other) {
            if (other !== checkbox) {
              other.checked = false;
            }
          });
        });
      });
    }
  };

})(Drupal, once);
