(function (Drupal, once) {

  Drupal.behaviors.ViewerTabs = {
    attach: function (context, settings) {
      once('viewer-tabs', '.viewer-tabs-wrapper', context).forEach(function (wrapper) {

        // Change tab class and display content
        const tabLinks = wrapper.querySelectorAll('.tabs__tab.tabs-viewer a');
        tabLinks.forEach(function (link) {
          link.addEventListener('click', function (event) {
            event.preventDefault();

            const parent = this.parentElement;
            const tabsWrapper = parent.closest('.tabs-wrapper');

            // Remove is-active from all tabs and links
            tabsWrapper.querySelectorAll('.is-active').forEach(function (el) {
              el.classList.remove('is-active');
            });

            // Add is-active to current tab
            parent.classList.add('is-active');
            this.classList.add('is-active');

            // Hide all tab content
            wrapper.querySelectorAll('.tabs-viewer .tabs-viewer-content').forEach(function (content) {
              content.style.display = 'none';
              const table = content.querySelector('.viewer-table');
              if (table) {
                table.style.width = '100%';
              }
            });

            // Show selected tab content
            const targetId = this.getAttribute('href');
            if (targetId) {
              // Use getElementById for IDs that may start with numbers
              const targetContent = document.getElementById(targetId.replace('#', ''));
              if (targetContent) {
                targetContent.style.display = '';
              }
            }
          });
        });

        // Trigger click on active tab
        const activeTab = wrapper.querySelector('.tabs__tab.tabs-viewer a.is-active');
        if (activeTab) {
          activeTab.click();
        }

      });
    }
  };

})(Drupal, once);
