/**
 * Viewer library.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    define(factory);
  } else if (typeof exports === 'object') {
    module.exports = factory();
  } else {
    root.Viewer = factory();
  }
}(this, function() {

  "use strict";

  function Viewer() {}

  /**
   * Load Viewer Sources.
   *
   * @param {string} uuid - The viewer UUID.
   * @param {HTMLElement|jQuery} wrapper - The wrapper DOM element or jQuery object.
   * @param {Function} callback - Callback function to handle the response.
   */
  Viewer.prototype.load = function(uuid, wrapper, callback) {
    // Support both jQuery objects and native DOM elements
    const element = wrapper instanceof HTMLElement ? wrapper : wrapper[0];

    const markup = '<div class="viewer-loader"><div class="overlay"></div>'
      + '<img src="' + drupalSettings.viewer.path + '/assets/loader.svg" border="0" />'
      + '<div class="loading-taking-time"></div></div>';
    element.insertAdjacentHTML('beforeend', markup);

    const loader = element.querySelector('.viewer-loader');
    loader.classList.remove('hidden');

    setTimeout(function() {
      const loadingText = element.querySelector('.loading-taking-time');
      if (loadingText) {
        loadingText.innerHTML = 'Loading is taking longer than expected...';
      }
    }, 15000);

    fetch(getDomainWithPort() + 'get/viewer/' + uuid + '?_format=json')
      .then(function(response) {
        return response.json();
      })
      .then(function(data) {
        callback(data);
        loader.classList.add('hidden');
        // Make hidden elements visible.
        element.querySelectorAll('.viewer-hidden').forEach(function(el) {
          el.classList.remove('viewer-hidden');
        });
      });
  };

  /**
   * Helper function to get current domain.
   */
  function getDomainWithPort() {
    if (!window.location.origin) {
      window.location.origin = window.location.protocol + "//" + window.location.hostname
        + (window.location.port ? ':' + window.location.port : '');
    }
    return window.location.origin + drupalSettings.path.baseUrl;
  }

  return Viewer;

}));
