<?php

namespace Drupal\viewer\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a Viewer plugin attribute.
 *
 * Plugin Namespace: Plugin\viewer\viewer.
 *
 * @see \Drupal\viewer\Plugin\ViewerManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class Viewer extends Plugin {

  /**
   * Constructs a Viewer attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $name
   *   The plugin name.
   * @param bool $empty_viewer_source
   *   Whether this plugin works without the viewer source.
   * @param array $viewer_types
   *   Array of supported Viewer Types.
   * @param string|null $processor
   *   Data processor plugin ID.
   * @param bool $filters
   *   Whether this plugin supports filters.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $name = NULL,
    public readonly bool $empty_viewer_source = FALSE,
    public readonly array $viewer_types = [],
    public readonly ?string $processor = NULL,
    public readonly bool $filters = FALSE,
    public readonly ?string $deriver = NULL,
  ) {}

}
