<?php

namespace Drupal\viewer\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a ViewerCell plugin attribute.
 *
 * Plugin Namespace: Plugin\viewer\cell.
 *
 * @see \Drupal\viewer\Plugin\ViewerCellManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class ViewerCell extends Plugin {

  /**
   * Constructs a ViewerCell attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $name
   *   The plugin name.
   * @param array $viewers
   *   Applicable list of viewers.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $name = NULL,
    public readonly array $viewers = [],
    public readonly ?string $deriver = NULL,
  ) {}

}
