<?php

namespace Drupal\viewer\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Defines a ViewerProcessor plugin attribute.
 *
 * Plugin Namespace: Plugin\viewer\processor.
 *
 * @see \Drupal\viewer\Plugin\ViewerProcessorManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class ViewerProcessor extends Plugin {

  /**
   * Constructs a ViewerProcessor attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?string $deriver = NULL,
  ) {}

}
