<?php

namespace Drupal\viewer\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a ViewerSource plugin attribute.
 *
 * Plugin Namespace: Plugin\viewer\source.
 *
 * @see \Drupal\viewer\Plugin\ViewerSourceManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class ViewerSource extends Plugin {

  /**
   * Constructs a ViewerSource attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $name
   *   The plugin name.
   * @param bool $cron
   *   Whether the plugin can run on cron.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $name = NULL,
    public readonly bool $cron = FALSE,
    public readonly ?string $deriver = NULL,
  ) {}

}
