<?php

namespace Drupal\viewer\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a ViewerType plugin attribute.
 *
 * Plugin Namespace: Plugin\viewer\type.
 *
 * @see \Drupal\viewer\Plugin\ViewerTypeManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class ViewerType extends Plugin {

  /**
   * Constructs a ViewerType attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $name
   *   The plugin name.
   * @param array $extensions
   *   Associative array of extensions => mime type.
   * @param string|null $default_viewer
   *   Default viewer plugin ID.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $name = NULL,
    public readonly array $extensions = [],
    public readonly ?string $default_viewer = NULL,
    public readonly ?string $deriver = NULL,
  ) {}

}
