<?php

namespace Drupal\viewer\Commands;

use Drupal\viewer\Services\Cron;
use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;

/**
 * ViewerCommands drush commands.
 */
class ViewerCommands extends DrushCommands {

  /**
   * Constructor.
   *
   * @param \Drupal\viewer\Services\Cron $cron
   *   Cron service.
   */
  public function __construct(
    protected Cron $cron,
  ) {
    parent::__construct();
  }

  /**
   * Drush command to run Viewer automated imports.
   */
  #[CLI\Command(name: 'viewer:import', aliases: ['vimp'])]
  #[CLI\Help(description: 'Run Viewer automated imports.')]
  public function import(): void {
    $this->cron->processQueue();
  }

}
